/*
 * Decompiled with CFR 0.152.
 */
package reliquary.util.potions;

import com.google.common.base.MoreObjects;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;
import reliquary.items.PotionEssenceItem;
import reliquary.util.potions.EffectComparator;
import reliquary.util.potions.PotionIngredient;
import reliquary.util.potions.PotionMap;

public class XRPotionHelper {
    private static final String EFFECTS_TAG = "effects";
    private static final String EFFECTS_NBT_TAG = "effects";
    private static final int MAX_DURATION = 36000;
    private static final int MAX_AMPLIFIER = 4;
    private static final MobEffect[] nonAugmentableEffects = new MobEffect[]{MobEffects.f_19610_, MobEffects.f_19604_, MobEffects.f_19609_, MobEffects.f_19611_, MobEffects.f_19608_};

    private XRPotionHelper() {
    }

    public static boolean isItemEssence(ItemStack stack) {
        return stack.m_41720_() instanceof PotionEssenceItem;
    }

    public static boolean isIngredient(ItemStack stack) {
        for (PotionIngredient ingredient : PotionMap.ingredients) {
            if (!ingredient.getItem().m_41720_().getRegistryName().equals((Object)stack.m_41720_().getRegistryName())) continue;
            return true;
        }
        return false;
    }

    public static Optional<PotionIngredient> getIngredient(ItemStack stack) {
        if (stack.m_41720_() instanceof PotionEssenceItem) {
            return Optional.of(new PotionIngredient(stack, XRPotionHelper.getPotionEffectsFromStack(stack)));
        }
        for (PotionIngredient ingredient : PotionMap.ingredients) {
            if (!ingredient.getItem().m_41720_().getRegistryName().equals((Object)stack.m_41720_().getRegistryName())) continue;
            return Optional.of(ingredient);
        }
        return Optional.empty();
    }

    private static boolean isAugmentablePotionEffect(MobEffectInstance effect) {
        for (MobEffect nonAugmentableEffect : nonAugmentableEffects) {
            if (nonAugmentableEffect != effect.m_19544_()) continue;
            return false;
        }
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void addPotionTooltip(List<MobEffectInstance> effects, List<Component> list) {
        if (!effects.isEmpty()) {
            ArrayList list1 = Lists.newArrayList();
            for (MobEffectInstance potioneffect : effects) {
                Object s1 = I18n.m_118938_((String)potioneffect.m_19576_(), (Object[])new Object[0]).trim();
                MobEffect potion = potioneffect.m_19544_();
                Map map = potion.m_19485_();
                if (!map.isEmpty()) {
                    for (Map.Entry entry : map.entrySet()) {
                        AttributeModifier attributemodifier = (AttributeModifier)entry.getValue();
                        AttributeModifier attributemodifier1 = new AttributeModifier(attributemodifier.m_22214_(), potion.m_7048_(potioneffect.m_19564_(), attributemodifier), attributemodifier.m_22217_());
                        list1.add(new Tuple((Object)((Attribute)entry.getKey()).m_22087_(), (Object)attributemodifier1));
                    }
                }
                if (potioneffect.m_19564_() > 0) {
                    s1 = (String)s1 + " " + I18n.m_118938_((String)("potion.potency." + potioneffect.m_19564_()), (Object[])new Object[0]).trim();
                }
                if (potioneffect.m_19557_() > 20) {
                    s1 = (String)s1 + " (" + MobEffectUtil.m_19581_((MobEffectInstance)potioneffect, (float)1.0f) + ")";
                }
                if (potion.m_19486_()) {
                    list.add((Component)new TextComponent(ChatFormatting.BLUE + (String)s1));
                    continue;
                }
                list.add((Component)new TextComponent(ChatFormatting.RED + (String)s1));
            }
            if (!list1.isEmpty()) {
                list.add((Component)new TextComponent(""));
                list.add((Component)new TextComponent(ChatFormatting.DARK_PURPLE + I18n.m_118938_((String)"potion.whenDrank", (Object[])new Object[0])));
                for (Tuple tuple : list1) {
                    AttributeModifier attributemodifier2 = (AttributeModifier)tuple.m_14419_();
                    double d0 = attributemodifier2.m_22218_();
                    double d1 = attributemodifier2.m_22217_() != AttributeModifier.Operation.MULTIPLY_BASE && attributemodifier2.m_22217_() != AttributeModifier.Operation.MULTIPLY_TOTAL ? attributemodifier2.m_22218_() : attributemodifier2.m_22218_() * 100.0;
                    if (d0 > 0.0) {
                        list.add((Component)new TranslatableComponent("attribute.modifier.plus." + attributemodifier2.m_22217_().m_22235_(), new Object[]{ItemStack.f_41584_.format(d1), new TranslatableComponent((String)tuple.m_14418_())}).m_130940_(ChatFormatting.BLUE));
                        continue;
                    }
                    if (!(d0 < 0.0)) continue;
                    list.add((Component)new TranslatableComponent("attribute.modifier.take." + attributemodifier2.m_22217_().m_22235_(), new Object[]{ItemStack.f_41584_.format(d1 *= -1.0), new TranslatableComponent((String)tuple.m_14418_())}).m_130940_(ChatFormatting.RED));
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void addPotionTooltip(ItemStack stack, List<Component> list) {
        XRPotionHelper.addPotionTooltip(XRPotionHelper.getPotionEffectsFromStack(stack), list);
    }

    public static void addPotionEffectsToCompoundTag(CompoundTag tag, Collection<MobEffectInstance> effects) {
        if (effects.isEmpty()) {
            return;
        }
        ListTag effectList = tag.m_128437_("effects", 10);
        for (MobEffectInstance object : effects) {
            CompoundTag effect = new CompoundTag();
            effect.m_128359_("name", object.m_19544_().getRegistryName().toString());
            effect.m_128405_("duration", object.m_19544_().m_8093_() ? 1 : object.m_19557_());
            effect.m_128405_("potency", object.m_19564_());
            effectList.add((Object)effect);
        }
        tag.m_128365_("effects", (Tag)effectList);
    }

    public static List<MobEffectInstance> getPotionEffectsFromCompoundTag(CompoundTag tag) {
        if (!tag.m_128441_("effects")) {
            return Lists.newArrayList();
        }
        ListTag effectList = tag.m_128437_("effects", 10);
        ArrayList ret = Lists.newArrayList();
        for (Tag effectTag : effectList) {
            CompoundTag effect = (CompoundTag)effectTag;
            String registryName = effect.m_128461_("name");
            int duration = effect.m_128451_("duration");
            int potency = effect.m_128451_("potency");
            ret.add(new MobEffectInstance((MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(new ResourceLocation(registryName)), duration, potency));
        }
        return ret;
    }

    public static List<MobEffectInstance> getPotionEffectsFromStack(ItemStack stack) {
        if (!stack.m_41782_()) {
            return Collections.emptyList();
        }
        return XRPotionHelper.getPotionEffectsFromCompoundTag(stack.m_41783_());
    }

    public static void addPotionEffectsToStack(ItemStack itemstack, List<MobEffectInstance> effects) {
        CompoundTag tag = (CompoundTag)MoreObjects.firstNonNull((Object)itemstack.m_41783_(), (Object)new CompoundTag());
        XRPotionHelper.addPotionEffectsToCompoundTag(tag, effects);
        itemstack.m_41751_(tag);
    }

    public static void cleanPotionEffects(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag == null) {
            return;
        }
        if (tag.m_128441_("effects")) {
            tag.m_128473_("effects");
        }
    }

    public static List<MobEffectInstance> changePotionEffectsDuration(Collection<MobEffectInstance> effects, float factor) {
        ArrayList ret = Lists.newArrayList();
        for (MobEffectInstance effect : effects) {
            int newDuration = (int)(effect.m_19544_().m_8093_() ? 1.0f : (float)effect.m_19557_() * factor);
            ret.add(new MobEffectInstance(effect.m_19544_(), newDuration, effect.m_19564_(), effect.m_19571_(), effect.m_19572_()));
        }
        return ret;
    }

    public static List<MobEffectInstance> augmentPotionEffects(List<MobEffectInstance> effects, int redstoneCount, int glowstoneCount) {
        return XRPotionHelper.addRedstone(XRPotionHelper.addGlowstone(effects, glowstoneCount), redstoneCount);
    }

    private static List<MobEffectInstance> addRedstone(List<MobEffectInstance> effects, int redstoneCount) {
        if (redstoneCount <= 0) {
            return effects;
        }
        ArrayList<MobEffectInstance> newEffects = new ArrayList<MobEffectInstance>();
        int effectCnt = effects.size();
        double multiplier = 1.0;
        for (int redstoneLevel = 1; redstoneLevel <= redstoneCount; ++redstoneLevel) {
            multiplier *= (double)(8 + effectCnt) / (double)(3 + effectCnt) - 1.0 / (double)(3 + effectCnt) * ((double)redstoneLevel - 1.0);
        }
        for (MobEffectInstance effect : effects) {
            int newDuration = (int)((double)effect.m_19557_() * multiplier);
            newDuration = Math.min(newDuration, 72000);
            MobEffectInstance newEffect = new MobEffectInstance(effect.m_19544_(), newDuration, effect.m_19564_(), effect.m_19571_(), effect.m_19572_());
            newEffects.add(newEffect);
        }
        return newEffects;
    }

    private static List<MobEffectInstance> addGlowstone(List<MobEffectInstance> effects, int glowstoneCount) {
        if (glowstoneCount <= 0) {
            return effects;
        }
        ArrayList<MobEffectInstance> newEffects = new ArrayList<MobEffectInstance>();
        int effectCnt = effects.size();
        double multiplier = 1.0;
        for (int glowstoneLevel = 1; glowstoneLevel <= glowstoneCount; ++glowstoneLevel) {
            multiplier *= (double)(11 + effectCnt) / (double)(6 + effectCnt) - 1.0 / (double)(6 + effectCnt) * (double)glowstoneLevel - 1.0;
        }
        for (MobEffectInstance effect : effects) {
            int newAmplifier = effect.m_19564_();
            if (XRPotionHelper.isAugmentablePotionEffect(effect)) {
                newAmplifier = Math.min(effect.m_19564_() + glowstoneCount, 5);
            }
            MobEffectInstance newEffect = new MobEffectInstance(effect.m_19544_(), (int)((double)effect.m_19557_() * multiplier), newAmplifier, effect.m_19571_(), effect.m_19572_());
            newEffects.add(newEffect);
        }
        return newEffects;
    }

    static List<MobEffectInstance> combineIngredients(PotionIngredient ... ingredients) {
        return XRPotionHelper.combineIngredients(Arrays.asList(ingredients));
    }

    public static List<MobEffectInstance> combineIngredients(Collection<PotionIngredient> ingredients) {
        HashMap potionEffectCounterList = new HashMap();
        ArrayList<ResourceLocation> potionEffectList = new ArrayList<ResourceLocation>();
        for (PotionIngredient ingredient : ingredients) {
            for (MobEffectInstance effect : ingredient.getEffects()) {
                if (potionEffectCounterList.containsKey(effect.m_19544_().getRegistryName())) {
                    if (!potionEffectList.contains(effect.m_19544_().getRegistryName())) {
                        potionEffectList.add(effect.m_19544_().getRegistryName());
                    }
                    ((List)potionEffectCounterList.get(effect.m_19544_().getRegistryName())).add(effect);
                    continue;
                }
                ArrayList<MobEffectInstance> effects = new ArrayList<MobEffectInstance>();
                effects.add(effect);
                potionEffectCounterList.put(effect.m_19544_().getRegistryName(), effects);
            }
        }
        ArrayList combinedEffects = Lists.newArrayList();
        for (ResourceLocation potionName : potionEffectList) {
            MobEffect potion;
            List effects = (List)potionEffectCounterList.get(potionName);
            int duration = XRPotionHelper.getCombinedDuration(effects);
            int amplifier = XRPotionHelper.getCombinedAmplifier(effects);
            if (duration == 0 || (potion = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(potionName)) == null) continue;
            combinedEffects.add(new MobEffectInstance(potion, duration, amplifier));
        }
        combinedEffects.sort(new EffectComparator());
        return combinedEffects;
    }

    private static int getCombinedAmplifier(List<MobEffectInstance> effects) {
        int amplifier = 0;
        for (MobEffectInstance effect : effects) {
            amplifier += effect.m_19564_();
        }
        return Math.min(amplifier, 4);
    }

    private static int getCombinedDuration(List<MobEffectInstance> effects) {
        int count = 0;
        int duration = 0;
        for (MobEffectInstance effect : effects) {
            if (effect.m_19544_().m_8093_()) {
                return 1;
            }
            ++count;
            duration += effect.m_19557_();
        }
        duration = (int)((double)duration / 1.2);
        if (count == 3) {
            duration = (int)((double)duration / 1.1);
        }
        return Math.min(duration, 36000);
    }

    public static void applyEffectsToEntity(Collection<MobEffectInstance> effects, Entity source, @Nullable Entity indirectSource, LivingEntity entitylivingbase) {
        XRPotionHelper.applyEffectsToEntity(effects, source, indirectSource, entitylivingbase, 1.0);
    }

    public static void applyEffectsToEntity(Collection<MobEffectInstance> effects, Entity source, @Nullable Entity indirectSource, LivingEntity entitylivingbase, double amplifier) {
        for (MobEffectInstance potioneffect : effects) {
            if (potioneffect.m_19544_().m_8093_()) {
                potioneffect.m_19544_().m_19461_(source, indirectSource, entitylivingbase, potioneffect.m_19564_(), amplifier);
                continue;
            }
            int j = (int)(amplifier * (double)potioneffect.m_19557_() + 0.5);
            if (j <= 20) continue;
            entitylivingbase.m_7292_(new MobEffectInstance(potioneffect.m_19544_(), j, potioneffect.m_19564_(), false, false));
        }
    }
}

